/*
 * Decompiled with CFR 0.152.
 */
package me.angel.blocksfloat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.angel.blocksfloat.BlocksFloat;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("blocksfloat.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final boolean DEFAULT_ENABLED = false;
    private static final boolean DEFAULT_SHOW_PARTICLES = false;
    private static final boolean DEFAULT_PAUSE_ON_STANDING = false;
    private static final boolean DEFAULT_FLOAT_MOBS = false;
    private static final int DEFAULT_RADIUS = 20;
    private static final int DEFAULT_INTENSITY = 1;
    private static final int DEFAULT_MAX_FLOAT_HEIGHT = 100;
    private static final int DEFAULT_MOVE_INTERVAL = 10;
    private static final int DEFAULT_RAYCAST_DISTANCE = 64;
    private boolean enabled = false;
    private boolean showParticles = false;
    private boolean pauseOnStanding = false;
    private boolean floatMobs = false;
    private int radius = 20;
    private int intensity = 1;
    private int maxFloatHeight = 100;
    private int moveInterval = 10;
    private int maxRaycastDistance = 64;

    public static ModConfig load() {
        ModConfig config = new ModConfig();
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                config = (ModConfig)GSON.fromJson(json, ModConfig.class);
                BlocksFloat.LOGGER.info("Loaded BlocksFloat config");
            }
            catch (IOException e) {
                BlocksFloat.LOGGER.error("Failed to load BlocksFloat config", (Throwable)e);
            }
        } else {
            config.save();
            BlocksFloat.LOGGER.info("Created default BlocksFloat config");
        }
        return config;
    }

    public void save() {
        try {
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
            BlocksFloat.LOGGER.info("Saved BlocksFloat config");
        }
        catch (IOException e) {
            BlocksFloat.LOGGER.error("Failed to save BlocksFloat config", (Throwable)e);
        }
    }

    public void resetToDefaults() {
        this.enabled = false;
        this.showParticles = false;
        this.pauseOnStanding = false;
        this.floatMobs = false;
        this.radius = 20;
        this.intensity = 1;
        this.maxFloatHeight = 100;
        this.moveInterval = 10;
        this.maxRaycastDistance = 64;
        this.save();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.save();
    }

    public boolean isShowParticles() {
        return this.showParticles;
    }

    public void setShowParticles(boolean showParticles) {
        this.showParticles = showParticles;
        this.save();
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.save();
    }

    public int getIntensity() {
        return this.intensity;
    }

    public void setIntensity(int intensity) {
        this.intensity = intensity;
        this.save();
    }

    public int getMaxFloatHeight() {
        return this.maxFloatHeight;
    }

    public void setMaxFloatHeight(int maxFloatHeight) {
        this.maxFloatHeight = maxFloatHeight;
        this.save();
    }

    public int getMoveInterval() {
        return this.moveInterval;
    }

    public void setMoveInterval(int moveInterval) {
        this.moveInterval = moveInterval;
        this.save();
    }

    public int getMaxRaycastDistance() {
        return this.maxRaycastDistance;
    }

    public void setMaxRaycastDistance(int maxRaycastDistance) {
        this.maxRaycastDistance = maxRaycastDistance;
        this.save();
    }

    public boolean isPauseOnStanding() {
        return this.pauseOnStanding;
    }

    public void setPauseOnStanding(boolean pauseOnStanding) {
        this.pauseOnStanding = pauseOnStanding;
        this.save();
    }

    public boolean isFloatMobs() {
        return this.floatMobs;
    }

    public void setFloatMobs(boolean floatMobs) {
        this.floatMobs = floatMobs;
        this.save();
    }
}

